import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay_agent/core/helper/date_converter.dart';
import 'package:viserpay_agent/core/helper/string_format_helper.dart';
import 'package:viserpay_agent/core/utils/dimensions.dart';
import 'package:viserpay_agent/core/utils/my_color.dart';
import 'package:viserpay_agent/core/utils/my_strings.dart';
import 'package:viserpay_agent/data/controller/add_money/add_money_history_controller.dart';
import 'package:viserpay_agent/view/components/column_widget/card_column.dart';
import 'package:viserpay_agent/view/components/divider/custom_divider.dart';
import 'package:viserpay_agent/view/screens/add-money/add_money_history/widget/add_money_history_bottom_sheet.dart';
import 'package:viserpay_agent/view/screens/withdrawals/withdraw_history/widget/status_widget.dart';

class AddMoneyHistoryCard extends StatelessWidget {
  final int index;
  const AddMoneyHistoryCard({super.key, required this.index});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<AddMoneyHistoryController>(
      builder: (controller) => GestureDetector(
        onTap: () => AddMoneyHistoryBottomSheet.addMoneyHistoryBottomSheet(context: context, index: index),
        child: Container(
          width: MediaQuery.of(context).size.width,
          padding: const EdgeInsets.symmetric(horizontal: Dimensions.space15, vertical: Dimensions.space15),
          decoration: BoxDecoration(color: MyColor.colorWhite, borderRadius: BorderRadius.circular(Dimensions.defaultRadius)),
          child: Column(
            children: [
              Row(
                crossAxisAlignment: CrossAxisAlignment.start,
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  CardColumn(header: MyStrings.trx, body: controller.depositList[index].trx ?? ""),
                  CardColumn(alignmentEnd: true, header: MyStrings.date, body: DateConverter.isoStringToLocalDateOnly(controller.depositList[index].createdAt ?? "")),
                ],
              ),
              const CustomDivider(space: Dimensions.space10),
              Row(
                crossAxisAlignment: CrossAxisAlignment.end,
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  CardColumn(header: MyStrings.amount, body: "${Converter.formatNumber(controller.depositList[index].amount ?? "", precision: 2)} ${controller.currency} "),
                  StatusWidget(
                    status: controller.getStatusOrColor(index),
                    color: controller.getStatusOrColor(index, isStatus: false),
                  ),
                ],
              ),
            ],
          ),
        ),
      ),
    );
  }
}
